package gov.va.med.mhv.usermgmt.service.adapter;

import java.util.Properties;

import gov.va.med.mhv.core.util.PropertiesUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.config.ConfigurationManager;

public class PhrConfigProperties {
    private static final Log LOG = LogFactory.getLog(MpiProperties.class);
    
    private static final String RESOURCE_NAME = "/phr-config.properties";
    
    private static final boolean reload = PropertiesUtil.getReloadProperties();
    private static PhrConfigProperties INSTANCE = new PhrConfigProperties();
    
    private int connectTimeout;
    private int requestTimeout;
    private final boolean newphr_enabled;
    private final String newphr_env_type;
    private final String newphr_env_wsdlurl;
    private final String newphr_auth_key;
    
    private static final String NEWPHR_ENABLED 		= "newphr.enabled";
    private static final String CONNECT_TIMEOUT	 	= "newphr.connect.timeout";
    private static final String REQUEST_TIMEOUT 	= "newphr.request.timeout";
    private static final String ENV_TYPE 			= "newphr.env.type";
    private static final String AUTH_KEY 			= "newphr.auth.key";
    private static final String ENV_WSDLURL1 		=	"newphr.";
    private static final String ENV_WSDLURL2 		= ".wsdlurl";
    
    public static PhrConfigProperties getInstance() {
        return (reload) ? new PhrConfigProperties() : INSTANCE;
    }

	private PhrConfigProperties() {
        Properties properties = ConfigurationManager.getConfiguration(
            RESOURCE_NAME);

        connectTimeout 			= PropertiesUtil.getIntValue(RESOURCE_NAME, properties, CONNECT_TIMEOUT, 0);
        connectTimeout			= connectTimeout*1000;
        requestTimeout			= PropertiesUtil.getIntValue(RESOURCE_NAME, properties, REQUEST_TIMEOUT, 0);
        requestTimeout			= requestTimeout*1000;
        newphr_enabled 			= PropertiesUtil.getBooleanValue(RESOURCE_NAME, properties, NEWPHR_ENABLED, false);
        newphr_env_type 		= PropertiesUtil.getValue (RESOURCE_NAME, properties, ENV_TYPE, "");
        newphr_auth_key			= PropertiesUtil.getValue (RESOURCE_NAME, properties, AUTH_KEY, "");
        String env_wsdlUrl 		= ENV_WSDLURL1 + newphr_env_type + ENV_WSDLURL2;
        newphr_env_wsdlurl 		= PropertiesUtil.getValue (RESOURCE_NAME, properties, env_wsdlUrl, "");
        
        if (LOG.isInfoEnabled()) {
            LOG.info("Using " + describe());
        }
	}


	public boolean isNewphr_enabled() {
		return newphr_enabled;
	}

	public String getNewphr_env_type() {
		return newphr_env_type;
	}

	public String getNewphr_env_wsdlurl() {
		return newphr_env_wsdlurl;
	}

	public int getConnectTimeout() {
		return connectTimeout;
	}

	public int getRequestTimeout() {
		return requestTimeout;
	}

	public String getNewphr_auth_key() {
		return newphr_auth_key;
	}

	private String describe() {

        StringBuilder builder = new StringBuilder();
        builder.append("PhrConfigProperties [ ");
        builder.append(" newphr_env_type=").append(newphr_env_type);
        builder.append("; newphr_env_wsdlurl=").append(newphr_env_wsdlurl);
        builder.append("; connection timeout=").append(connectTimeout);
        builder.append("; request timeout=").append(requestTimeout);
        builder.append("; Auth Key =").append(newphr_auth_key);
        builder.append("]");

        return builder.toString();
		
	}
    

}
